<?php

namespace App\Http\Controllers\Admin;

use App\Categories;
use App\GalleryImage;
use App\Http\Controllers\Controller;
use App\Libraries\Utils;
use App\PostRatings;
use App\Posts;
use App\PostTags;
use App\Sources;
use App\SubCategories;
use App\Tags;
use App\Users;
use Illuminate\Support\Str;
use Input;
use Session;

class RatingsController extends Controller
{
    public function all()
    {

        $ratings = PostRatings::all();

        foreach ($ratings as $r) {
            $r->post = Posts::where('id', $r->post_id)->first();
        }

        return view('admin.ratings.all', ['ratings' => $ratings]);
    }

    public function delete($id)
    {
        if (!is_null($id) && sizeof(PostRatings::where('id', $id)->get()) > 0) {

            PostRatings::where('id', $id)->delete();

            Session::flash('success_msg', 'Rating deleted successfully');
            return redirect()->to('/admin/ratings/all');

        } else {
            Session::flash('error_msg', 'Rating not found');
            return redirect()->to('/admin/ratings/all');
        }
    }

}